//***********************************************************************
//Copyright © 2009-2013 Corporation for National Research Initiatives
//("CNRI"). This software is made available under the terms of the
//CNRI License Agreement  that is located at hdl:1895.26/1012
//or http://hdl.handle.net/1895.26/1012.
//***********************************************************************
//Developer: Kevin Hosford
//Developer: Robert R Tupelo-Schneck <schneck@cnri.reston.va.us>
//***********************************************************************
const NATIVECID = Components.ID("4f47e42e-4d23-4dd3-bfda-eb29255e9ea3");
const SCHEME = "http";
const PROTOCOL_NAME = "http protocol handler which redirects to hdl and doi";
const PROTOCOL_CONTRACTID = "@mozilla.org/network/protocol;1?name=" + SCHEME;
const PROTOCOL_CID = Components.ID("1edb2bc0-8361-11de-8a39-0800200c9a66");

const Cc = Components.classes;
const Ci = Components.interfaces;

function dump(msg) {
    Cc["@mozilla.org/consoleservice;1"]
        .getService(Ci.nsIConsoleService)
            .logStringMessage(msg);
}

var savedHttpHandler = null;
var hdlHandler = null; // lazily initialized
var prefService = null; 

var proxyArray = null;
var prefObserver = {
    observe: function(subject, topic, data) {     
        // dump("proxyObserve");
        try {
            var theProxies = prefService.getCharPref("proxyValues");
            if(theProxies==null) proxyArray = null;
            else {
                theProxies = theProxies.replace(/^\s+|\s+$/g,"");
                if(theProxies.length==0) {
                    proxyArray = null;                
                }
                else if(theProxies.indexOf("\n") != -1) {
                    proxyArray = theProxies.split("\n");
                }
                else {
                    proxyArray = [theProxies];
                }
            }
        }
        catch(e) {
            proxyArray = null;
        }
    }
};

/*************************************************/
/****** Protocol Stuff ***************************/
function hdlHttpProtocol() {
    if(savedHttpHandler==null) {
        savedHttpHandler = Components.classesByID["{4f47e42e-4d23-4dd3-bfda-eb29255e9ea3}"].getService(Ci.nsIHttpProtocolHandler);    
    }
    
//    try {
//        hdlHandler = Cc["@mozilla.org/network/protocol;1?name=hdl"].getService(Ci.nsIProtocolHandler);
//    }
//    catch(err) {
//        dump(err);
//    }
    if(prefService==null) {
        prefService = Cc["@mozilla.org/preferences-service;1"].getService(Ci.nsIPrefService);
        prefService = prefService.getBranch("extensions.cnri-handle.").QueryInterface(Ci.nsIPrefBranch2);
        prefService.addObserver("proxyValues", prefObserver, false);
        prefObserver.observe(null,null,null);
    }
    
    // a little magic to copy everything else
    // note: this seems to fail badly for functions (specifically newURI)
    for(att in savedHttpHandler) {
        if(!(att in this)) {
            this[att] = savedHttpHandler[att];
        }
    }
};

hdlHttpProtocol.prototype = {
    /*nsISupports*/
    QueryInterface: function(iid) {
        if (iid.equals(Ci.nsISupports) ||
            iid.equals(Ci.nsISupportsWeakReference) ||
            iid.equals(Ci.nsIProtocolHandler) ||
            iid.equals(Ci.nsIProxiedProtocolHandler) ||
            iid.equals(Ci.nsIHttpProtocolHandler))
            return this;
        return savedHttpHandler.QueryInterface(iid);
    },
    
    // changeable attribute of nsIHttpProtocolHandler
    // don't know if I need to do this, but better safe
    get appName() { return savedHttpHandler.appName; },
    set appName(v) { savedHttpHandler.appName = v; },
    get appVersion() { return savedHttpHandler.appVersion; },
    set appVersion(v) { savedHttpHandler.appVersion = v; },
    get language() { return savedHttpHandler.language; },
    set language(v) { savedHttpHandler.language = v; },
    get misc() { return savedHttpHandler.misc; },
    set misc(v) { savedHttpHandler.misc = v; },
    get oscpu() { return savedHttpHandler.oscpu; },
    set oscpu(v) { savedHttpHandler.oscpu = v; },
    get platform() { return savedHttpHandler.platform; },
    set platform(v) { savedHttpHandler.platform = v; },
    get product() { return savedHttpHandler.product; },
    set product(v) { savedHttpHandler.product = v; },
    get productComment() { return savedHttpHandler.productComment; },
    set productComment(v) { savedHttpHandler.productComment = v; },
    get productSub() { return savedHttpHandler.productSub; },
    set productSub(v) { savedHttpHandler.productSub = v; },
    get userAgent() { return savedHttpHandler.userAgent; },
    set userAgent(v) { savedHttpHandler.userAgent = v; },
    get vendor() { return savedHttpHandler.vendor; },
    set vendor(v) { savedHttpHandler.vendor = v; },
    get vendorComment() { return savedHttpHandler.vendorComment; },
    set vendorComment(v) { savedHttpHandler.vendorComment = v; },
    get vendorSub() { return savedHttpHandler.vendorSub; },
    set vendorSub(v) { savedHttpHandler.vendorSub = v; },
    get deviceType() { return savedHttpHandler.deviceType; },
    set deviceType(v) { savedHttpHandler.deviceType = v; },
    
    /*nsIProxiedProtocolHandler*/
    newProxiedChannel: function(uri , proxyInfo, proxyResolveFlags, proxyURI) {
        return this.newChannelHelper(uri, proxyInfo, proxyResolveFlags, proxyURI, true);
    },
    newProxiedChannel2: function(uri , proxyInfo, proxyResolveFlags, proxyURI, loadInfo) {
        return this.newChannelHelper(uri, proxyInfo, proxyResolveFlags, proxyURI, true, loadInfo);
    },

    /*nsIProtocolHandler*/
    newURI: function(spec, charset, baseURI) {
        var locationURI = savedHttpHandler.newURI(spec, charset, baseURI);
//        var check = this.checkURI(locationURI);
//        if(check) return check.locationURI;
        return locationURI;
    },

    allowPort: function(port, scheme) {
        return savedHttpHandler.allowPort(port,scheme);
    },
    
    /*Get new channel  */
    newChannel: function(locationURI) {
        return this.newChannelHelper(locationURI, null, null, null, false);
    },
    newChannel2: function(locationURI, loadInfo) {
        return this.newChannelHelper(locationURI, null, null, null, false, loadInfo);
    },
    
    checkURI: function(locationURI) {
        var path = locationURI.path;
        while(path.indexOf('/')==0) path = path.substr(1);
        var useHdl = path.indexOf("forceProxy") <= path.indexOf("?");
        useHdl = useHdl && path.length > 0 && path.indexOf("favicon.ico") != 0 && path.indexOf("index.html") != 0 && path.indexOf("static") != 0;
        if(useHdl) {
            var host = locationURI.host;
            var port = locationURI.port;
            if(port != -1 && port != 80) host = host + ":" + port;
            var theDomain = "hdl.handle.net";
            useHdl = host == theDomain;
            if(!useHdl) {
                theDomain = "dx.doi.org";
                useHdl = host == theDomain;
                if(!useHdl) {
                    if (host == "doi.org") {
                        if(path.indexOf('.')<0 && path.indexOf('/')<0) {
                            // shortdoi
                            useHdl = true;
                            path = "10/" + path;
                        }
                        else {
                            var n = path.indexOf('.');
                            if(n<0) {
                                n = path.indexOf('/');
                            }
                            else {
                                var m = path.indexOf('/');
                                if(m>=0 && m<n) n = m;
                            }
                            var prefix = path.substring(0,n);
                            useHdl = true;
                            for(var i = 0; i < n; i++) {
                                var ch = prefix.charAt(i);
                                if(ch<'0' || ch>'9') {
                                    useHdl = false;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            var currProxyArray = proxyArray;
            if(!useHdl && currProxyArray!=null) {
                for(var i = 0; !useHdl && i < currProxyArray.length; ++i) {
                    theDomain = currProxyArray[i].replace(/^\s+|\s+$/g,"");
                    useHdl = host == theDomain;
                }
            }
    
            if(useHdl) {
                if(useHdl && hdlHandler==null) {
                    try {
                        hdlHandler = Cc["@mozilla.org/network/protocol;1?name=hdl"].getService(Ci.nsIProtocolHandler);
                    }
                    catch(err) {
                        dump(err);
                    }
                    useHdl = hdlHandler!=null;
                }
                if(useHdl) {
                    var theHandle;
                    if(theDomain.indexOf("doi") != -1) {
                        theHandle = "doi:" + path;
                    } else {
                        theHandle = "hdl:" + path;
                    }
                    locationURI = hdlHandler.newURI(theHandle,null,null);
                }
            }
        }
        if(useHdl) {
            return { theDomain:theDomain, locationURI:locationURI };
        }
        else {
            return null;
        }
    },
    
    newChannelHelper: function(locationURI, proxyInfo, proxyResolveFlags, proxyURI, isProxiedChannel, loadInfo) {
        var check = this.checkURI(locationURI);
        if(check) {
        	var ret;
        	if (loadInfo) {
                ret = hdlHandler.newChannel2(check.locationURI, loadInfo);
        	} else {
                ret = hdlHandler.newChannel(check.locationURI);
        	}
            if(ret.wrappedJSObject) {
                ret.wrappedJSObject.proxy = "http://" + check.theDomain;
                ret.wrappedJSObject.proxyURI = locationURI;
            }
            return ret;
        } else {
            if(isProxiedChannel) {
                if(proxyResolveFlags!=undefined) {
                	if (loadInfo) {
                		return savedHttpHandler.newProxiedChannel2(locationURI,proxyInfo,proxyResolveFlags,proxyURI,loadInfo);
                	} else {
                		return savedHttpHandler.newProxiedChannel(locationURI,proxyInfo,proxyResolveFlags,proxyURI);
                	}
                } else {
                	return savedHttpHandler.newProxiedChannel(locationURI,proxyInfo);
                }
            }
            else {
            	if (loadInfo) {
            		return savedHttpHandler.newChannel2(locationURI, loadInfo);
            	} else {
            		return savedHttpHandler.newChannel(locationURI);
            	}
            }
        }
    }
}


/*************************************************/
/******* Factory Stuff ***************************/
var hdlHttpFactory = {
    /*nsIFactory*/
    createInstance: function(outer, iid) {
        if(outer != null) throw Cr.NS_ERROR_NO_AGGREGATION;
//        return Components.classesByID["{4f47e42e-4d23-4dd3-bfda-eb29255e9ea3}"].getService(Ci.nsIHttpProtocolHandler);
        // dump("createInstance");
        return (new hdlHttpProtocol()).QueryInterface(iid);
    },

    /*nsISupports*/
    QueryInterface: function(iid) {
        if (iid.equals(Ci.nsISupports) ||
            iid.equals(Ci.nsISupportsWeakReference) ||
            iid.equals(Ci.nsIFactory))
          return this;
        throw Components.results.NS_ERROR_NO_INTERFACE;
    }
}

/**************************************************/
/** XPCOM Registration ****************************/
var hdlHttpModule = new Object();

hdlHttpModule.registerSelf = function (compMgr, fileSpec, location, type)
{
    // better to access by contract than by CID, in case someone else has fiddled with it too
    try {
        savedHttpHandler = Cc[PROTOCOL_CONTRACTID].getService(Ci.nsIHttpProtocolHandler);
    }
    catch(e) {
    }
    if(savedHttpHandler==null) {
        savedHttpHandler = Components.classesByID["{4f47e42e-4d23-4dd3-bfda-eb29255e9ea3}"].getService(Ci.nsIHttpProtocolHandler);    
    }
   
    // Fix needed for 3.0 and 3.5
    // assuming we're running under Firefox
    var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                            .getService(Components.interfaces.nsIXULAppInfo);
    var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                                   .getService(Components.interfaces.nsIVersionComparator);
    if(versionChecker.compare(appInfo.version, "3.6") < 0) {
        // running under Firefox 3.5 or earlier
        delete hdlHttpProtocol.prototype.appName;
        delete hdlHttpProtocol.prototype.appVersion;
        delete hdlHttpProtocol.prototype.language;
        delete hdlHttpProtocol.prototype.misc;
        delete hdlHttpProtocol.prototype.oscpu;
        delete hdlHttpProtocol.prototype.platform;
        delete hdlHttpProtocol.prototype.product;
        delete hdlHttpProtocol.prototype.productComment;
        delete hdlHttpProtocol.prototype.productSub;
        delete hdlHttpProtocol.prototype.userAgent;
        delete hdlHttpProtocol.prototype.vendor;
        delete hdlHttpProtocol.prototype.vendorComment;
        delete hdlHttpProtocol.prototype.vendorSub;
        delete hdlHttpProtocol.prototype.deviceType;
    }
    
    compMgr.QueryInterface(Ci.nsIComponentRegistrar)
        .registerFactoryLocation(PROTOCOL_CID, PROTOCOL_NAME, PROTOCOL_CONTRACTID, fileSpec, location, type);
}

hdlHttpModule.unregisterSelf = function(compMgr, location, loaderStr) {
    compMgr = compMgr.QueryInterface(Ci.nsIComponentRegistrar);
    compMgr.unregisterFactoryLocation(PROTOCOL_CID, location);
}

hdlHttpModule.getClassObject = function (compMgr, cid, iid)
{
  if (!cid.equals(PROTOCOL_CID))
    throw Components.results.NS_ERROR_NO_INTERFACE;

  if (!iid.equals(Ci.nsIFactory))
    throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

  return hdlHttpFactory;
}

hdlHttpModule.canUnload = function (compMgr)
{
  return true;
}

function NSGetModule(compMgr, fileSpec)
{
  return hdlHttpModule;
}

function NSGetFactory(cid) {
    return hdlHttpFactory;
}
